# src/youtube_api.py

import os
from googleapiclient.discovery import build
from google_auth_oauthlib.flow import InstalledAppFlow
from google.auth.transport.requests import Request
from google.oauth2.credentials import Credentials

SCOPES = [
    "https://www.googleapis.com/auth/youtube.force-ssl",
    "https://www.googleapis.com/auth/blogger"
]

def authenticate(credentials_path, token_path):
    """
    Authenticate the user and return the credentials.
    """
    creds = None
    # Check if token.json exists
    if os.path.exists(token_path):
        creds = Credentials.from_authorized_user_file(token_path, SCOPES)
    # If there are no valid credentials, let the user log in.
    if not creds or not creds.valid:
        if creds and creds.expired and creds.refresh_token:
            creds.refresh(Request())
        else:
            flow = InstalledAppFlow.from_client_secrets_file(credentials_path, SCOPES)
            creds = flow.run_local_server(port=0)
        # Save the credentials for the next run
        with open(token_path, 'w') as token_file:
            token_file.write(creds.to_json())
    return creds

def search_top_video(youtube, query, max_results=1):
    """
    Search for the top video based on the query and return the first result.
    """
    request = youtube.search().list(
        part="snippet",
        q=query,
        maxResults=max_results,
        order="viewCount",
        type="video"
    )
    response = request.execute()
    if 'items' in response and len(response['items']) > 0:
        return response['items'][0]
    else:
        return None
