# src/blogger_api.py

from googleapiclient.discovery import build

def authenticate_blogger(credentials):
    """
    Authenticate and return the Blogger API client.
    """
    blogger = build("blogger", "v3", credentials=credentials)
    return blogger

def create_blog_post(blogger, blog_id, title, content, labels=None):
    """
    Create a new blog post on Blogger.
    """
    post_body = {
        "title": title,
        "content": content
    }
    if labels:
        post_body["labels"] = labels
    request = blogger.posts().insert(blogId=blog_id, body=post_body)
    response = request.execute()
    return response
